#!/bin/sh
# Copyright (c) 2003-2013 Synology Inc. All rights reserved.

SYNOINFO_CONF="/etc/synoinfo.conf"

syslog() {
    local ret=$?
    logger -p user.err -t $(basename $0) "$@"
    return $ret
}

case $1 in
"start")
	NeedReindex=0
	ReindexMusicOnly=0

	echo "Update media type table where type id = 0 to test db existence"
	su -l postgres -c "/usr/bin/psql mediaserver -c \"select 1 from music limit 1\""
	Ret=$?
	if [ $Ret = 2 ]; then
		su -l postgres -c "/usr/bin/createdb mediaserver"
		if [ $? != 0 ]; then
			echo "Failed to create database"
			exit
		fi
		Script="/usr/syno/synoindex/sql/mediaserver.pgsql"
		Ret=1
	fi

	if [ $Ret = 1 ]; then
		su -l postgres -c "/usr/bin/psql mediaserver < $Script"
		if [ $? != 0 ]; then
			echo "Failed to initial media database"
			exit
		fi

		NeedReindex=1
	fi

	upgrades=`find /usr/syno/synoindex/sql/upgrade -name "*.sh" | sort`
	for ThisArg in $upgrades;
	do
		$ThisArg
		Ret=$?
		if [ $Ret = 1 ]; then
			NeedReindex=1

			if [ "$ThisArg" = "/usr/syno/synoindex/sql/upgrade/006_create_virtual_music_table.sh" ]; then
				# hard coded if this is the only upgrade script, re-index music type only
				ReindexMusicOnly=1
			fi
		fi
	done

	if [ $NeedReindex = 1 ]; then
		if [ $ReindexMusicOnly = 1 ]; then
			cmd="/usr/syno/bin/synoindex -R type_music -P MediaIndex"
		else
			cmd="/usr/syno/bin/synoindex -R media -P MediaIndex"
		fi

		`$cmd`

		message="Re-index triggered, cmd [$cmd]"
		syslog "$message"
		echo "$message"
	fi

	;;
*)
	echo "Usage: $0 start"
	;;
esac
